/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	LikeList
**
** DESCRIPTION:	A list of things a villager likes
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef LIKE_LIST_H
#define LIKE_LIST_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "LikeTypes.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int LikeList_c_iMaxLikes = 3;
const int LikeList_c_iMaxInitialLikes = 2;
const int LikeList_c_iChanceOfLikingSomething = 25;	// (1-100)

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CLikeList
{
private:

	//class data
	ELike		m_eLike[LikeList_c_iMaxLikes];

	//class methods
	//setup
	public:		CLikeList();
	public:		void Reset();
	public:		void Initialize();

	//process
	public:		const bool Add(ELike eLike);
	public:		const bool Remove(ELike eLike);

	//access
	public:		const bool Contains(ELike eLike) const;
	public:		const char *GetListAsString() const;
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/